/**
* Responsive
* 
* author: Thilo Ilg
* version: 1.1.5
* 
**/

/** 
* --- jAlbumGlobals ---
* jAlbumGlobals is responsible for constant parameter of the skin.
* In the process of creating an album the jAlbum parser will overwrite 
* the variables according to the skin with the selected ones in the
* program. jAlbumGlobals also includes global variables which describe
* the state of the skin like if it is embedded, viewed on a mobile device,
* online or in filesystem etc.
*/
var jAlbumGlobals = (function () {

	var styles = ["dark.css", "light.css", "transparent.css"]; // styles

	var mobile = isMobile(); // is the skin viewed on a mobile device
	var online = isOnline(); // is the skin viewed online or in the filesystem
	var jAlbumURL = getURL(); // what's the current url?

	var stylePath = ""; //path points to the styles folder
	var resPath = ""; // path points to the res folder

	var credits = "Fotoalbum Websites mit jAlbum erstellen"; // should skin show credits in footer
	var albumTitle = "Kriegers Warrior"; // what's the album title?
	var contentPath = ""; // path points to the skin folder
	var imgHoverScaleFactor = "scale(1.1)"; // scale factor of hovering an element

	var folderTitleUp = true; // positioning of folder title, under or above folder
	var folderImgCount = false; // says if folder deep count should be shown
	var maxImgInRow = 10; // restricts the number of elements in a row
	var imgBorderSize = 3; // define border size of element
	var imgBoxSize = 175; // defines size of container of element
	var showFolderName = false; // says if folder name should be displayed
	var textSize = 11; // defines text size of whole page
	var showComments = true; // defines if comments should be shown in slideshow
	var slideBorderSize = 0;
	var slideBorderColor = "#ff000000";
	var style = "dark.css";

	var dataTree = {"path":"Kriegers%20Warrior","counters":{"total":21,"images":21,"files":21},"objects":[{"path":"IMG_9851.JPG","image":{"path":"slides\/IMG_9851.JPG","width":1536,"height":1024},"thumb":{"path":"thumbs\/IMG_9851.JPG","width":256,"height":171},"fileSize":3547180,"name":"IMG_9851.JPG","comment":"Fußraste","fileDate":"2011-02-22T17:17:18.0Z","category":"image","camera":{"aperture":4.5,"exposureTime":"1\/60s","originalDate":"2011-02-22T18:17:50.0Z","cameraModel":"Canon EOS 1000D","focalLength35mm":"53.5mm","resolution":"3888 x 2592","cameraMake":"Canon","isoEquivalent":400,"flash":"Flash fired","focalLength":"33.0mm"}},{"path":"IMG_0033.JPG","image":{"path":"slides\/IMG_0033.JPG","width":1536,"height":1024},"thumb":{"path":"thumbs\/IMG_0033.JPG","width":256,"height":171},"fileSize":4079451,"name":"IMG_0033.JPG","comment":"Cover","fileDate":"2011-03-18T15:03:38.0Z","category":"image","camera":{"aperture":3.5,"exposureTime":"1\/60s","originalDate":"2011-03-18T16:06:46.0Z","cameraModel":"Canon EOS 1000D","focalLength35mm":"38.9mm","resolution":"3888 x 2592","cameraMake":"Canon","isoEquivalent":400,"flash":"Flash fired","focalLength":"24.0mm"}},{"path":"IMG_0038.JPG","image":{"path":"slides\/IMG_0038.JPG","width":1536,"height":1024},"thumb":{"path":"thumbs\/IMG_0038.JPG","width":256,"height":171},"fileSize":3004861,"name":"IMG_0038.JPG","comment":"Bremsstange mit Drucksensor","fileDate":"2011-03-18T15:03:41.0Z","category":"image","camera":{"aperture":4.0,"exposureTime":"1\/60s","originalDate":"2011-03-18T16:08:19.0Z","cameraModel":"Canon EOS 1000D","focalLength35mm":"43.8mm","resolution":"3888 x 2592","cameraMake":"Canon","isoEquivalent":400,"flash":"Flash fired","focalLength":"27.0mm"}},{"path":"IMG_0049.JPG","image":{"path":"slides\/IMG_0049.JPG","width":1536,"height":1024},"thumb":{"path":"thumbs\/IMG_0049.JPG","width":256,"height":171},"fileSize":3345532,"name":"IMG_0049.JPG","comment":"Armatur","fileDate":"2011-03-20T20:02:05.0Z","category":"image","camera":{"aperture":4.0,"exposureTime":"1\/60s","originalDate":"2011-03-20T19:06:59.0Z","cameraModel":"Canon EOS 1000D","focalLength35mm":"40.5mm","resolution":"3888 x 2592","cameraMake":"Canon","isoEquivalent":400,"flash":"Flash fired","focalLength":"25.0mm"}},{"path":"IMG_0229.JPG","image":{"path":"slides\/IMG_0229.JPG","width":1536,"height":1024},"thumb":{"path":"thumbs\/IMG_0229.JPG","width":256,"height":171},"fileSize":3292498,"name":"IMG_0229.JPG","comment":"Verlegter Bremsanker","fileDate":"2011-05-17T20:35:22.0Z","category":"image","camera":{"aperture":4.5,"exposureTime":"1\/60s","originalDate":"2011-05-17T19:55:13.0Z","cameraModel":"Canon EOS 1000D","focalLength35mm":"50.3mm","resolution":"3888 x 2592","cameraMake":"Canon","isoEquivalent":400,"flash":"Flash fired","focalLength":"31.0mm"}},{"path":"IMG_0419.JPG","image":{"path":"slides\/IMG_0419.JPG","width":1536,"height":1024},"thumb":{"path":"thumbs\/IMG_0419.JPG","width":256,"height":171},"fileSize":3118984,"name":"IMG_0419.JPG","comment":"Selbst hergestellter Kennzeichenhalter","fileDate":"2011-07-05T07:18:57.0Z","category":"image","camera":{"aperture":4.0,"exposureTime":"1\/6s","originalDate":"2011-07-04T22:07:14.0Z","cameraModel":"Canon EOS 1000D","focalLength35mm":"48.6mm","resolution":"3888 x 2592","cameraMake":"Canon","isoEquivalent":800,"flash":"Flash did not fire, auto","focalLength":"30.0mm"}},{"path":"IMG_0415.JPG","image":{"path":"slides\/IMG_0415.JPG","width":1024,"height":1536},"thumb":{"path":"thumbs\/IMG_0415.JPG","width":171,"height":256},"fileSize":4006522,"name":"IMG_0415.JPG","comment":"240'er Hinterreifen","fileDate":"2011-07-05T07:21:03.0Z","category":"image","camera":{"aperture":4.0,"exposureTime":"1\/20s","originalDate":"2011-07-04T22:06:23.0Z","cameraModel":"Canon EOS 1000D","focalLength35mm":"40.5mm","resolution":"2592 x 3888","cameraMake":"Canon","isoEquivalent":800,"flash":"Flash did not fire, auto","focalLength":"25.0mm"}},{"path":"IMG_0966.JPG","image":{"path":"slides\/IMG_0966.JPG","width":1536,"height":1024},"thumb":{"path":"thumbs\/IMG_0966.JPG","width":256,"height":171},"fileSize":3706272,"name":"IMG_0966.JPG","comment":"Bugspoiler","fileDate":"2012-07-10T07:13:02.0Z","category":"image","camera":{"aperture":5.6,"exposureTime":"1\/125s","originalDate":"2012-07-09T20:32:21.0Z","cameraModel":"Canon EOS 1000D","focalLength35mm":"76.2mm","resolution":"3888 x 2592","cameraMake":"Canon","isoEquivalent":400,"flash":"Flash fired","focalLength":"47.0mm"}},{"path":"IMG_0978.JPG","image":{"path":"slides\/IMG_0978.JPG","width":1536,"height":1024},"thumb":{"path":"thumbs\/IMG_0978.JPG","width":256,"height":171},"fileSize":3458381,"name":"IMG_0978.JPG","comment":"Gekürzte Roadburner Auspuffanlage","fileDate":"2012-07-10T07:13:11.0Z","category":"image","camera":{"aperture":5.0,"exposureTime":"1\/40s","originalDate":"2012-07-09T20:36:43.0Z","cameraModel":"Canon EOS 1000D","focalLength35mm":"45.4mm","resolution":"3888 x 2592","cameraMake":"Canon","isoEquivalent":200,"flash":"Flash did not fire","focalLength":"28.0mm"}},{"path":"DSC_0250.jpg","image":{"path":"slides\/DSC_0250.jpg","width":1536,"height":1020},"thumb":{"path":"thumbs\/DSC_0250.jpg","width":256,"height":170},"fileSize":4635111,"name":"DSC_0250.jpg","comment":"Paintjob","fileDate":"2012-10-07T17:22:24.0Z","category":"image","camera":{"aperture":2.2,"exposureTime":"1\/250s","originalDate":"2012-09-29T15:35:35.0Z","cameraModel":"NIKON D90","focusDistance":"3.98m","focalLength35mm":"129.5mm","resolution":"4288 x 2848","cameraMake":"NIKON CORPORATION","isoEquivalent":800,"flash":"Flash did not fire","focalLength":"85.0mm"}},{"path":"0173%20Yamaha%20solo.jpg","image":{"path":"slides\/0173%20Yamaha%20solo.jpg","width":1000,"height":665},"thumb":{"path":"thumbs\/0173%20Yamaha%20solo.jpg","width":256,"height":170},"fileSize":435145,"name":"0173 Yamaha solo.jpg","comment":"Fotoshooting","fileDate":"2012-10-06T17:43:08.0Z","category":"image"},{"path":"DSC_0179.jpg","image":{"path":"slides\/DSC_0179.jpg","width":1536,"height":1020},"thumb":{"path":"thumbs\/DSC_0179.jpg","width":256,"height":170},"fileSize":5992221,"name":"DSC_0179.jpg","comment":"Fotoshooting","fileDate":"2012-10-06T20:35:57.0Z","category":"image","camera":{"aperture":2.2,"exposureTime":"1\/640s","originalDate":"2012-09-29T15:05:23.0Z","cameraModel":"NIKON D90","focusDistance":"9.44m","focalLength35mm":"129.5mm","resolution":"4288 x 2848","cameraMake":"NIKON CORPORATION","isoEquivalent":800,"flash":"Flash did not fire","focalLength":"85.0mm"}},{"path":"DSC_0209.jpg","image":{"path":"slides\/DSC_0209.jpg","width":1536,"height":1020},"thumb":{"path":"thumbs\/DSC_0209.jpg","width":256,"height":170},"fileSize":5182932,"name":"DSC_0209.jpg","comment":"Fotoshooting","fileDate":"2012-10-07T15:36:39.0Z","category":"image","camera":{"aperture":2.2,"exposureTime":"1\/800s","originalDate":"2012-09-29T15:16:42.0Z","cameraModel":"NIKON D90","focusDistance":"11.2m","focalLength35mm":"129.5mm","resolution":"4288 x 2848","cameraMake":"NIKON CORPORATION","isoEquivalent":800,"flash":"Flash did not fire","focalLength":"85.0mm"}},{"path":"DSC_0234.jpg","image":{"path":"slides\/DSC_0234.jpg","width":1536,"height":1020},"thumb":{"path":"thumbs\/DSC_0234.jpg","width":256,"height":170},"fileSize":8406147,"name":"DSC_0234.jpg","comment":"Fotoshooting","fileDate":"2012-10-07T16:59:56.0Z","category":"image","camera":{"aperture":2.2,"exposureTime":"1\/500s","originalDate":"2012-09-29T15:27:41.0Z","cameraModel":"NIKON D90","focusDistance":"11.2m","focalLength35mm":"129.5mm","resolution":"4288 x 2848","cameraMake":"NIKON CORPORATION","isoEquivalent":800,"flash":"Flash did not fire","focalLength":"85.0mm"}},{"path":"DSC_0240.jpg","image":{"path":"slides\/DSC_0240.jpg","width":1536,"height":1020},"thumb":{"path":"thumbs\/DSC_0240.jpg","width":256,"height":170},"fileSize":5776327,"name":"DSC_0240.jpg","comment":"Fotoshooting","fileDate":"2012-10-07T17:06:32.0Z","category":"image","camera":{"aperture":2.2,"exposureTime":"1\/640s","originalDate":"2012-09-29T15:29:05.0Z","cameraModel":"NIKON D90","focusDistance":"7.94m","focalLength35mm":"129.5mm","resolution":"4288 x 2848","cameraMake":"NIKON CORPORATION","isoEquivalent":800,"flash":"Flash did not fire","focalLength":"85.0mm"}},{"path":"DSC_0242.jpg","image":{"path":"slides\/DSC_0242.jpg","width":1536,"height":1020},"thumb":{"path":"thumbs\/DSC_0242.jpg","width":256,"height":170},"fileSize":5047461,"name":"DSC_0242.jpg","comment":"Fotoshooting","fileDate":"2012-10-07T17:11:44.0Z","category":"image","camera":{"aperture":2.2,"exposureTime":"1\/500s","originalDate":"2012-09-29T15:29:46.0Z","cameraModel":"NIKON D90","focusDistance":"11.2m","focalLength35mm":"129.5mm","resolution":"4288 x 2848","cameraMake":"NIKON CORPORATION","isoEquivalent":800,"flash":"Flash did not fire","focalLength":"85.0mm"}},{"path":"DSC_0247.jpg","image":{"path":"slides\/DSC_0247.jpg","width":1536,"height":1020},"thumb":{"path":"thumbs\/DSC_0247.jpg","width":256,"height":170},"fileSize":5327035,"name":"DSC_0247.jpg","comment":"Fotoshooting","fileDate":"2012-10-07T17:20:25.0Z","category":"image","camera":{"aperture":2.2,"exposureTime":"1\/320s","originalDate":"2012-09-29T15:33:29.0Z","cameraModel":"NIKON D90","focusDistance":"9.44m","focalLength35mm":"129.5mm","resolution":"4288 x 2848","cameraMake":"NIKON CORPORATION","isoEquivalent":800,"flash":"Flash did not fire","focalLength":"85.0mm"}},{"path":"DSC_0254.jpg","image":{"path":"slides\/DSC_0254.jpg","width":1020,"height":1536},"thumb":{"path":"thumbs\/DSC_0254.jpg","width":170,"height":256},"fileSize":4875218,"name":"DSC_0254.jpg","comment":"Fotoshooting","fileDate":"2012-10-07T17:42:24.0Z","category":"image","camera":{"aperture":2.2,"exposureTime":"1\/2000s","originalDate":"2012-09-29T15:38:11.0Z","cameraModel":"NIKON D90","focusDistance":"6.68m","focalLength35mm":"129.5mm","resolution":"2848 x 4288","cameraMake":"NIKON CORPORATION","isoEquivalent":800,"flash":"Flash did not fire","focalLength":"85.0mm"}},{"path":"DSC_0384.jpg","image":{"path":"slides\/DSC_0384.jpg","width":1536,"height":1020},"thumb":{"path":"thumbs\/DSC_0384.jpg","width":256,"height":170},"fileSize":5500363,"name":"DSC_0384.jpg","comment":"Fotoshooting","fileDate":"2012-10-10T22:08:53.0Z","category":"image","camera":{"aperture":2.2,"exposureTime":"1\/500s","originalDate":"2012-09-29T16:38:34.0Z","cameraModel":"NIKON D90","focusDistance":"9.44m","focalLength35mm":"129.5mm","resolution":"4288 x 2848","cameraMake":"NIKON CORPORATION","isoEquivalent":800,"flash":"Flash did not fire","focalLength":"85.0mm"}},{"path":"DSC_0386.jpg","image":{"path":"slides\/DSC_0386.jpg","width":1536,"height":1020},"thumb":{"path":"thumbs\/DSC_0386.jpg","width":256,"height":170},"fileSize":5479500,"name":"DSC_0386.jpg","comment":"Fotoshooting","fileDate":"2012-10-10T22:11:41.0Z","category":"image","camera":{"aperture":2.2,"exposureTime":"1\/640s","originalDate":"2012-09-29T16:38:52.0Z","cameraModel":"NIKON D90","focusDistance":"9.44m","focalLength35mm":"129.5mm","resolution":"4288 x 2848","cameraMake":"NIKON CORPORATION","isoEquivalent":800,"flash":"Flash did not fire","focalLength":"85.0mm"}},{"path":"IMG_1332.JPG","image":{"path":"slides\/IMG_1332.JPG","width":1536,"height":1024},"thumb":{"path":"thumbs\/IMG_1332.JPG","width":256,"height":171},"fileSize":3880661,"name":"IMG_1332.JPG","comment":"Custombike Show 2012","fileDate":"2012-12-08T10:49:43.0Z","category":"image","camera":{"aperture":3.5,"exposureTime":"1\/25s","originalDate":"2012-11-30T16:21:25.0Z","cameraModel":"Canon EOS 1000D","focalLength35mm":"29.2mm","resolution":"3888 x 2592","cameraMake":"Canon","isoEquivalent":250,"flash":"Flash did not fire, auto","focalLength":"18.0mm"}}],"name":"Kriegers Warrior","comment":"Bilder von Kriegers Warrior","fileDate":"2016-06-11T13:05:20.383Z"}; // includes all the album data in a json tree
	var stylePath = ""; 

	var widgetColor = getWidgetColor(); // get suggested color for widget support

	/** check if page viewed on mobile device **/
	function isMobile(){
		return (/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|ipad|iris|kindle|Android|Silk|lge |maemo|midp|mmp|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows (ce|phone)|xda|xiino/i.test(navigator.userAgent) 
	    || /1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i.test(navigator.userAgent.substr(0,4)));
	}

	/** check if page viewed online or from file system **/
	function isOnline(){
		switch(window.location.protocol) {
		   case 'http:':
		   		return true;
		   case 'https:':
		     	return true;
		   case 'file:':
		    	return false;
		}
	}

	/** get current url of page **/
	function getURL(){
		var curr = document.getElementById('jAlbum').src;
		return curr.substring(0, curr.lastIndexOf("/") + 1);
	}

	/** get fidget color according to current style **/
	function getWidgetColor(){
		if(style == styles[0]) return "black";
		else return "white";
	}

	/** returns all the public variables and functions **/
	return {
		mobile: mobile,
		online: online,
		jAlbumURL: jAlbumURL,
		stylePath: stylePath,
		resPath: resPath,
		credits: credits,
		albumTitle: albumTitle,
		contentPath: contentPath,
		imgHoverScaleFactor: imgHoverScaleFactor,
		folderTitleUp: folderTitleUp,
		folderImgCount: folderImgCount,
		maxImgInRow: maxImgInRow,
		imgBorderSize: imgBorderSize,
		imgBoxSize: imgBoxSize,
		showFolderName: showFolderName,
		textSize: textSize,
		showComments: showComments,
		dataTree: dataTree,
		stylePath: stylePath,
		slideBorderSize: slideBorderSize,
		slideBorderColor: slideBorderColor,
		widgetColor: widgetColor
	};

})();

/** --- jAlbumInject ---
* jAlbumInject is responsible for copying html code into
* the website. Stylesheet includes will be printed into
* the header, the body will be printed to the position
* of the embed code.
*/
var jAlbumInject = (function () {

	appendToHead(injLink('res/css/normalize.min.css', 'stylesheet')); // normalizes browser specific stylesheet defaults
	appendToHead(injLink('res/css/custom.min.css', 'stylesheet')); // customized desgin of the skin, will be partly overwritten by style.css
	appendToHead(injLink('res/styles.css', 'stylesheet')); // different styles to the skin which change the appearance

	appendToHead(injMeta("viewport", "width=device-width, initial-scale=1.0, maximum-scale=1.0")); // viewport handles mobile scaling size

	inj('<div id="Responsive" class="jAlbum">'); // Responsive id surrounds all code of the body of the skin
	inj('<div id="fullscreen"></div>'); // element where to add fullscreen
	inj('<div id="jAlbum-header"></div>'); // header container
	inj('<div id="jAlbum-content"></div>'); // content container
	inj('<div style="clear: both"></div>');

	inj('<div id="jAlbum-footer">'); // footer
	inj('<div class="left leaveFolder">');
	inj('<p><a onclick="jAlbumController.back();"> &#10096;</a></p>'); // go back button in footer
	inj('</div><div class="center"><p><a href="http://jalbum.net/">Fotoalbum Websites mit jAlbum erstellen</a> - '); // credits in footer
	inj('<a href="http://jalbum.net/skins/skin/Responsive">Responsive</a></p>'); // skin advertisement in footer
	inj('</div></div></div>'); // close footer

	inj('<script src="' + jAlbumGlobals.jAlbumURL + 'res/libs/jquery-2.1.4.min.js"></script>'); // embets jQuery library
	inj('<script type="text/javascript">$(document).bind("mobileinit", function(){$.extend($.mobile , {autoInitializePage: false})});</script>'); // deactivates jQuery unnecessary mobile feature
	inj('<script src="' + jAlbumGlobals.jAlbumURL + 'res/libs/jquery.mobile-1.4.5.min.js"></script>'); // includes jQuery Mobile
	inj('<script src="' + jAlbumGlobals.jAlbumURL + 'res/libs/jquery.touchswipe.min.js"></script>'); // jQuery touchswipe plugin
	inj('<script src="' + jAlbumGlobals.jAlbumURL + 'res/js/main.js" type="text/javascript"></script>'); // includes skin controller
	
	/** injects html code at embedded position **/
	function inj(html){
		document.write(html);
	}

	/** injects html code in header **/
	function appendToHead(elem){
		document.getElementsByTagName('head').item(0).appendChild(elem);
	}

	/** injects header of embedded page with stylesheet includes **/
	function injLink(path, rel){
		var elem = document.createElement("link");
		elem.href = jAlbumGlobals.jAlbumURL + path;
		elem.rel = rel;

		return elem;
	}

	function injMeta(name, content){
		var elem = document.createElement("meta");
		elem.name = name;
		elem.content = content;

		return elem;
	}

})();


/** --- Widget Support---
* provides JavaScript code for jAlbum widget support
*/
window._jaWidgetBarColor = jAlbumGlobals.widgetColor;

if(!document.getElementById('non-embedded')){ // check if embedded
	window._jaUrl = jAlbumGlobals.jAlbumURL;
	_jaSkin = "Responsive";
_jaStyle = "dark.css";
_jaVersion = "13.2.4";
_jaGeneratorType = "desktop";
_jaLanguage = "de";
_jaPageType = "index";
_jaRootPath = ".";
_jaUserId = "1038515";
var jalbumWidgetContainer = document.createElement('div');
jalbumWidgetContainer.setAttribute('id','jalbumwidgetcontainer');
var jalbumWidgetScript = document.createElement("script");
jalbumWidgetScript.type = "text/javascript";
jalbumWidgetScript.src = "http"+("https:"==document.location.protocol?"s":"")+"://jalbum.net/widgetapi/load.js";
jalbumWidgetScript.async = true;
jalbumWidgetContainer.appendChild(jalbumWidgetScript);
document.body.appendChild(jalbumWidgetContainer);
 // get JavaScript code for widget
}
